---@meta

---@class AText3DActor : AActor
---@field Text3DComponent UText3DComponent
local AText3DActor = {}



---@class FCachedFontData
---@field Font UFont
---@field TypefaceFontDataMap TMap<uint32, FTypefaceFontData>
local FCachedFontData = {}



---@class FCachedFontMeshes
---@field Glyphs TMap<uint32, UStaticMesh>
local FCachedFontMeshes = {}



---@class FGlyphMeshParameters
---@field Extrude float
---@field Bevel float
---@field BevelType EText3DBevelType
---@field BevelSegments int32
---@field bOutline boolean
---@field OutlineExpand float
---@field TypefaceIndex uint32
local FGlyphMeshParameters = {}



---@class FTypefaceFontData
---@field Meshes TMap<uint32, FCachedFontMeshes>
local FTypefaceFontData = {}



---@class UText3DCharacterTransform : USceneComponent
---@field bLocationEnabled boolean
---@field LocationProgress float
---@field LocationOrder EText3DCharacterEffectOrder
---@field LocationRange float
---@field LocationDistance FVector
---@field bScaleEnabled boolean
---@field ScaleProgress float
---@field ScaleOrder EText3DCharacterEffectOrder
---@field ScaleRange float
---@field ScaleBegin FVector
---@field ScaleEnd FVector
---@field bRotateEnabled boolean
---@field RotateProgress float
---@field RotateOrder EText3DCharacterEffectOrder
---@field RotateRange float
---@field RotateBegin FRotator
---@field RotateEnd FRotator
local UText3DCharacterTransform = {}

---@param Range float
function UText3DCharacterTransform:SetScaleRange(Range) end
---@param progress float
function UText3DCharacterTransform:SetScaleProgress(progress) end
---@param Order EText3DCharacterEffectOrder
function UText3DCharacterTransform:SetScaleOrder(Order) end
---@param Value FVector
function UText3DCharacterTransform:SetScaleEnd(Value) end
---@param bEnabled boolean
function UText3DCharacterTransform:SetScaleEnabled(bEnabled) end
---@param Value FVector
function UText3DCharacterTransform:SetScaleBegin(Value) end
---@param Range float
function UText3DCharacterTransform:SetRotateRange(Range) end
---@param progress float
function UText3DCharacterTransform:SetRotateProgress(progress) end
---@param Order EText3DCharacterEffectOrder
function UText3DCharacterTransform:SetRotateOrder(Order) end
---@param Value FRotator
function UText3DCharacterTransform:SetRotateEnd(Value) end
---@param bEnabled boolean
function UText3DCharacterTransform:SetRotateEnabled(bEnabled) end
---@param Value FRotator
function UText3DCharacterTransform:SetRotateBegin(Value) end
---@param Range float
function UText3DCharacterTransform:SetLocationRange(Range) end
---@param progress float
function UText3DCharacterTransform:SetLocationProgress(progress) end
---@param Order EText3DCharacterEffectOrder
function UText3DCharacterTransform:SetLocationOrder(Order) end
---@param bEnabled boolean
function UText3DCharacterTransform:SetLocationEnabled(bEnabled) end
---@param Distance FVector
function UText3DCharacterTransform:SetLocationDistance(Distance) end


---@class UText3DComponent : USceneComponent
---@field bRefreshOnChange boolean
---@field Text FText
---@field Extrude float
---@field Bevel float
---@field BevelType EText3DBevelType
---@field BevelSegments int32
---@field bOutline boolean
---@field OutlineExpand float
---@field FrontMaterial UMaterialInterface
---@field BevelMaterial UMaterialInterface
---@field ExtrudeMaterial UMaterialInterface
---@field BackMaterial UMaterialInterface
---@field Font UFont
---@field Typeface FName
---@field HorizontalAlignment EText3DHorizontalTextAlignment
---@field VerticalAlignment EText3DVerticalTextAlignment
---@field Kerning float
---@field LineSpacing float
---@field WordSpacing float
---@field bHasMaxWidth boolean
---@field MaxWidth float
---@field bHasMaxHeight boolean
---@field MaxHeight float
---@field bScaleProportionally boolean
---@field bCastShadow boolean
---@field TextRoot USceneComponent
---@field TextGeneratedDelegate FText3DComponentTextGeneratedDelegate
---@field CharacterKernings TArray<USceneComponent>
---@field CharacterMeshes TArray<UStaticMeshComponent>
local UText3DComponent = {}

function UText3DComponent:TextGenerated__DelegateSignature() end
---@param Value float
function UText3DComponent:SetWordSpacing(Value) end
---@param Value EText3DVerticalTextAlignment
function UText3DComponent:SetVerticalAlignment(Value) end
---@param Value FText
function UText3DComponent:SetText(Value) end
---@param Value boolean
function UText3DComponent:SetScaleProportionally(Value) end
---@param Value float
function UText3DComponent:SetOutlineExpand(Value) end
---@param Value float
function UText3DComponent:SetMaxWidth(Value) end
---@param Value float
function UText3DComponent:SetMaxHeight(Value) end
---@param Value float
function UText3DComponent:SetLineSpacing(Value) end
---@param Value float
function UText3DComponent:SetKerning(Value) end
---@param Value EText3DHorizontalTextAlignment
function UText3DComponent:SetHorizontalAlignment(Value) end
---@param bValue boolean
function UText3DComponent:SetHasOutline(bValue) end
---@param Value boolean
function UText3DComponent:SetHasMaxWidth(Value) end
---@param Value boolean
function UText3DComponent:SetHasMaxHeight(Value) end
---@param Value UMaterialInterface
function UText3DComponent:SetFrontMaterial(Value) end
---@param bFreeze boolean
function UText3DComponent:SetFreeze(bFreeze) end
---@param InFont UFont
function UText3DComponent:SetFont(InFont) end
---@param Value UMaterialInterface
function UText3DComponent:SetExtrudeMaterial(Value) end
---@param Value float
function UText3DComponent:SetExtrude(Value) end
---@param NewCastShadow boolean
function UText3DComponent:SetCastShadow(NewCastShadow) end
---@param Value EText3DBevelType
function UText3DComponent:SetBevelType(Value) end
---@param Value int32
function UText3DComponent:SetBevelSegments(Value) end
---@param Value UMaterialInterface
function UText3DComponent:SetBevelMaterial(Value) end
---@param Value float
function UText3DComponent:SetBevel(Value) end
---@param Value UMaterialInterface
function UText3DComponent:SetBackMaterial(Value) end
---@return TArray<FName>
function UText3DComponent:GetTypefaceNames() end
---@return FVector
function UText3DComponent:GetTextScale() end
---@return TArray<UStaticMeshComponent>
function UText3DComponent:GetGlyphMeshComponents() end
---@param Index int32
---@return UStaticMeshComponent
function UText3DComponent:GetGlyphMeshComponent(Index) end
---@return TArray<USceneComponent>
function UText3DComponent:GetGlyphKerningComponents() end
---@param Index int32
---@return USceneComponent
function UText3DComponent:GetGlyphKerningComponent(Index) end
---@return int32
function UText3DComponent:GetGlyphCount() end
---@return FText
function UText3DComponent:GetFormattedText() end
---@param Origin FVector
---@param BoxExtent FVector
function UText3DComponent:GetBounds(Origin, BoxExtent) end


---@class UText3DEngineSubsystem : UEngineSubsystem
---@field DefaultMaterial UMaterial
---@field CachedFonts TMap<uint32, FCachedFontData>
local UText3DEngineSubsystem = {}



